# Does `bitvec` Use Undefined Behavior

No. During the development of Miri, there were periods where performing integer
arithmetic on pointers was forbidden as the Miri team grew their understanding
of what the Rust language should and should not allow, and what they could and
could not prove.

As of the summer of 2019, Miri allows integer arithmetic on pointers performed
at runtime, which is what the `BitPtr` module does. As `BitPtr` is careful to
never change a pointer’s integer value in such a way that dereferencing it no
longer uses the original address, the behavior is fine. The machine never sees
the encoding process, and Miri allows the encoding to take place.

The other major source of UB is construction of aliased mutable references.

`bitvec` produced aliased mutable references upon demand via its
`BitSlice::split_at_mut` and `BitSlice::as_mut_slice` methods. This behavior has
been removed as of summer 2019: the crate uses `&Cell` instead of `&mut` for all
internal mutation, and when producing mutable references to memory, does not
include any shared memory elements that would alias.

The `unsafe` function `BitSlice::as_total_mut_slice` still produces mutable
references that can be made to alias. It is marked as `unsafe` so that users do
not blindly cause it to invoke undefined behavior.

A client using `bitvec` through only the safe API will never invoke undefined
behavior.

## This Seems Like A Short Document

It used to be much longer, back when both `bitvec` produced aliasing mutable
references and Miri disallowed the pointer arithmetic `bitvec` used for encoding
bitslice references.

Now that `bitvec` is better behaved and Miri is more permissive, the old
contents became obsolete and were deleted.
